* TAXSIMrename.do: Rename and label output variables from NBER TAXSIM calculator.

ren	v10	fedAGI
ren	v11	uiAGI
ren	v12	socsecAGI
ren	v13	zerobracket
ren	v14	persexemp
ren	v15	peps
ren	v16	dedphout
ren	v17	dedallowed
ren	v18	fedTI
ren	v19	fedTAX
ren	v20	surtaxexemp
ren	v21	taxcredit
ren	v22	chldcred
ren	v23	chldcredad
ren	v24	chldcare
ren	v25	eitc
ren	v26	amtTI		
ren	v27	amtLIAB		
ren	v28	fedTAXbc		
ren	v29	FICA		 // payroll tax for social security (Federal Insurance Contribution Act)
ren	v30	st_inc		
ren	v31	st_rent		
ren	v32	st_AGI		
ren	v33	st_exemp		
ren	v34	st_stdded		
ren	v35	st_itemded		
ren	v36	st_TI		
ren	v37	st_proptax		
ren	v38	st_chldcred		
ren	v39	st_eitc		
ren	v40	st_cred		
ren	v41	st_bracket		

label	var	fiitax              "net federal income tax liability"
label	var	siitax              "net state income tax liability"
label	var	fica                "FICA (OASDI and HI payroll tax, employee AND employer)"
label	var	frate              	"effective federal marginal rate on wage income"
label	var	srate               "effective state marginal rate on wage income"
label	var	ficar               "SocSec marginal rate (FICA rate)"
label	var	fedAGI             	"federal AGI"
label	var	uiAGI              	"UI in AGI"
label	var	socsecAGI           "Social Security in AGI"
label	var	zerobracket        	"zero bracket amount"
label	var	persexemp          	"personal exemptions phase-out"
label	var	peps               	"exemption phaseout"
label	var	dedphout           	"deduction phaseout"
label	var	dedallowed         	"deductions allowed (zero for non-itemizers)"
label	var	fedTI              	"federal taxable income"
label	var	fedTAX             	"federal regular tax"
label	var	surtaxexemp        	"exemption surtax"
label	var	taxcredit          	"general tax credit"
label	var	chldcred           	"child tax credit (as adjusted)"
label	var	chldcredad         	"refundable part of child tax credit"
label	var	chldcare           	"child care credit"
label	var	eitc               	"earned income tax credit (EITC)"
label	var	amtTI              	"income for the alternative minimum tax (AMT)"
label	var	amtLIAB            	"AMT liability (addition to regular tax)"
label	var	fedTAXbc          	"federal income tax before credits"
label	var	FICA               	"FICA"
label	var	st_inc             	"state household income"
label	var	st_rent            	"state rent payments"
label	var	st_AGI             	"state AGI"
label	var	st_exemp           	"state exemption amount"
label	var	st_stdded          	"state standard deduction"
label	var	st_itemded         	"state itemized deductions"
label	var	st_TI              	"state taxable income"
label	var	st_proptax         	"state property tax credit"
label	var	st_chldcred        	"state child care credit"
label	var	st_eitc            	"state earned income tax credit (EITC)"
label	var	st_cred            	"state total credits"
label	var	st_bracket         	"state bracket rate"
capture noisily: drop v10-v41	

label var year      "tax year"
label var state     "state of residence (SOI classification)"
label var mstat     "martial status"
label var depx      "number of dependents, i.e. dependent exemptions"
label var agex      "number of taxpayers over 65 year of age"
label var pwages    "wage and salary income of taxpayer (incl self-employment)"
label var swages    "wage and salary income of spouse (incl self-employment)"
label var dividends "dividend income"
label var otherprop "interest and other propery income
label var pensions  "taxable pensions"
label var gssi      "gross Social Security income"
label var transfers "other non-taxable transfer income"
label var rentpaid  "rent paid"
label var proptax   "property and other taxes paid except state income taxes"
label var otheritem "itemized deductions other than mortgage, state income tax, local property tax"
label var childcare "child care expenses"
label var ui        "unemployment compensation received"
label var depchild  "number of dependendents under age 17"
label var mortgage  "mortgage interest"
label var stcg      "short term capital gains or losses"
label var ltcg      "long term capital gains or losses"

				
